#!/bin/bash -l
#SBATCH --job-name="S2_MODELNO"
#SBATCH --account="d411-hector"
#SBATCH --time=05:30:00
#SBATCH --nodes=1	
#SBATCH --partition=gpu
#SBATCH --qos=gpu
#SBATCH --gres=gpu:1

module load nvidia/nvhpc

export OMP_NUM_THREADS=$SLURM_CPUS_PER_TASK
export CRAY_CUDA_MPS=1

modelID=MODELID

for ((time=INIT; time<ENDY; time=time+5))

do
    sed -i -e "s/_S2TIME/_${time}/" S2_DIRECTORY_modelMODELNO.ini
    sed -i -e "s/start=S2TIME/start=${time}/" S2_DIRECTORY_modelMODELNO.ini

    srun ./bin/MonoAlg3D -c S2_DIRECTORY_modelMODELNO.ini

    sed -i -e "s/_${time}/_S2TIME/" S2_DIRECTORY_modelMODELNO.ini
    sed -i -e "s/start=${time}/start=S2TIME/" S2_DIRECTORY_modelMODELNO.ini
done


